#include	<Speech.h>
#include	<Errors.h>
#include	<Gestalt.h>
#include	<FixMath.h>

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include "HTUtils.h"

#include "MacSpeech.h"
#include "MacInit.h"

/*
 * Globals.
 */

SpeechChannel		gSpeechChannel = nil;	// The current speech channel.
VoiceDescription	gVoiceDescription;		// A record containing useful (?) information.
short				gCountVoices,			// The number of voices available.
					gCurrentVoiceIndex;		// The number of the current voice.

char				gSayThis[255];			// The string that we want to say.

Boolean 				gSpeechOn = false;


void MacSpeakDocument(char * filename)
{
	OSErr err;
   char curr_line[256];
	FILE *fp = fopen(filename, "r");

	if (gSpeechOn)
	{
		err = StopSpeech(gSpeechChannel);
		if( err != noErr) HandleError(err);
		
	   if (fp) 
   	{
   		while (!feof(fp))
   		{
	   	 fgets(curr_line, 255, fp); 
   	 	 convert_to_speech(curr_line);		
   	 	 err = SpeakText(gSpeechChannel,(Ptr)curr_line,strlen(curr_line));
   	 	 while( SpeechBusy() )
					;
			 if (KeyPressed())
					break;
			if( err != noErr) HandleError(err);
	   	}
	   	fclose(fp);
	 	}
	 }
}

void MacSpeakString(char * theString)
{
	OSErr err;
	
	if (gSpeechOn)
	{	
			err = StopSpeech(gSpeechChannel);
		if( err != noErr) HandleError(err);

		err = SpeakText(gSpeechChannel,(Ptr)theString,strlen(theString));
		if( err != noErr) HandleError(err);
	}
}



/*
 * Use Gestalt to see if the Speech Manager is around.
 */

void TestForSpeechManager(void) 
{
	long	gestaltResult;
	OSErr	err;

	/*
	 * First, check to see if the speech manager is availiable
	 */	
	if ((err = Gestalt(gestaltSpeechAttr, &gestaltResult)) == noErr) 
		if ((gestaltResult & (1 << gestaltSpeechMgrPresent)) == 0)
			err = noSynthFound;
			
	if( err != noErr )
		HandleError(err);
	
	if(err == noErr)
	{
		gSpeechOn = (Initialize() == noErr);
	}
	else
		gSpeechOn = false;	
}

void CloseSpeechManager()
{
	OSErr err;
	if( gSpeechChannel != nil ) 
	{
			err = DisposeSpeechChannel(gSpeechChannel);
			if( err != noErr) HandleError(err);
	}	
}


/*
 * Initialize the voice, etc.
 */

OSErr Initialize(void) {
	OSErr	err;


	err = CountVoices(&gCountVoices);
	if( err != noErr) HandleError(err);

	return LoadVoice(1);
}

void MacSelectVoice(char * voice)
{
	OSErr		err;
	VoiceSpec	voiceSpec;
	VoiceDescription voiceDescription;
	
	int selectedVoice = -1;
	int i;
	
	
	if (gSpeechOn)
	{
		for (i=0; i < gCountVoices; i++)
		{
			err = GetIndVoice(i,&voiceSpec);
			if( err != noErr) HandleError(err);
	
			err = GetVoiceDescription(&voiceSpec,&voiceDescription,sizeof(voiceDescription));
			if( err != noErr) HandleError(err);
	
			if (!strcmp(PtoCstr((void *)voiceDescription.name),voice))
			{
				selectedVoice=i;
				break;
			}
		}
		if (selectedVoice != -1)
			LoadVoice(selectedVoice);
	}
}

OSErr LoadVoice(short index) {
	OSErr		err;
	VoiceSpec	voiceSpec;

	err = GetIndVoice(index,&voiceSpec);
	if( err != noErr) HandleError(err);

	/*
	 * Get the description and stash it in a global variable so other
	 * functions can get the info.
	 */

	err = GetVoiceDescription(&voiceSpec,&gVoiceDescription,sizeof(VoiceDescription));
	if( err != noErr) HandleError(err);

	/*
	 * So we can print with ANSI routines...
	 */

	//(void)PtoCstr((void *)gVoiceDescription.name);

	/*
	 * If there was an old channel, trash it.
	 */

	if( gSpeechChannel != nil ) {
		err = DisposeSpeechChannel(gSpeechChannel);
		if( err != noErr) HandleError(err);
		}

	/*
	 * Create a new channel using this voice specification. I don't know if
	 * this is necessary, maybe I can just assign a new voice spec to the
	 * channel somehow.
	 */

	err = NewSpeechChannel(&voiceSpec,&gSpeechChannel);
	if( err != noErr) HandleError(err);

	gCurrentVoiceIndex = index;

	return err;
	}


/*
 * Oops, something went wrong.
 */

void HandleError(OSErr err) 
{
	if (TRACE)
	{	
		fprintf(stderr,"\a\n\nSorry, an error occurred: ");

		switch( err ) {

		/*
		 * The Speech Manager errors.
		 */

		case noSynthFound:
			fprintf(stderr,"No synth found.\n");
			break;
		case synthOpenFailed:
			fprintf(stderr,"Synth open failed.\n");
			break;
		case synthNotReady:
			fprintf(stderr,"Synth not ready.\n");
			break;
		case bufTooSmall:
			fprintf(stderr,"Buffer too small.\n");
			break;
		case voiceNotFound:
			fprintf(stderr,"Voice not found.\n");
			break;
		case incompatibleVoice:
			fprintf(stderr,"Incompatible voice.\n");
			break;
		case badDictFormat:
			fprintf(stderr,"Bad dictionary format.\n");
			break;
		case badInputText:
			fprintf(stderr,"Bad input text.\n");
			break;

		/*
		 * Other errors that may occur.
		 */

		case gestaltUnknownErr:
			fprintf(stderr,"Gestalt doesn't have a clue.\n");
			break;
		case gestaltUndefSelectorErr:
			fprintf(stderr,"Unknown Gestalt selector.\n");
			break;
		case paramErr:
			fprintf(stderr,"Parameter error.\n");
			break;

		/*
		 * Default: print the number and quit.
		 */

		default:
			fprintf(stderr,"Error %d.\n",(int)err);
		}
	exit(EXIT_FAILURE);
	}
}


/*
 *  Convert lines to be more "speech" friendly by removing some chars
 */
void convert_to_speech(char *	string)
{
    char *s = string;

    if (!string)
        return;

    while (*s) 
    { 
		switch (*s) 
		{
		 case '*':
		 case '[':
		 case ']':		 
			*(s) = ' ';
	 	 break;
		}
		s++;
    }
    return;
}



